//	IC_Errors.h

#ifndef _H_IC_Errors
#define _H_IC_Errors

typedef enum {
	IC_Err_NONE, 
	IC_Err_OS, 
	IC_Err_BREAK_FROM_LOOP, 
	IC_Err_COULDNT_LOAD_DLG, 
	IC_Err_COULDNT_LOAD_DLG_ITEM, 
	IC_Err_WRONG_NUM_DLG_ITEMS, 
	IC_Err_ILLEGAL_CONVERSION, 
	IC_Err_UNSUPPORTED_IMAGE_TYPE, 
	IC_Err_NOT_DOS, 
	IC_Err_NOT_PRO, 
	IC_Err_NOT_PAS, 
	IC_Err_NOT_CPM, 
	IC_Err_OUT_OF_MEMORY, 
	IC_Err_UNSUPPORTED_FILE_SYSTEM, 
	IC_Err_CANT_READ_PRODOS_BLOCK, 
	IC_Err_NOT_REALLY_A_FOLDER, 
	IC_Err_CANT_LOCATE_FILE, 
	IC_Err_CANT_SEEK_FILE, 
	IC_Err_YOU_WILL_CRASH, 
	IC_Err_DIRECTORY_FULL, 
	IC_Err_DISK_FULL, 
	IC_Err_CANT_READ_NIB_DATA, 
	IC_Err_READ_ILLEGAL_DISK_BLOCK, 
	IC_Err_READ_ILLEGAL_FILE_BLOCK, 
	IC_Err_READ_ILLEGAL_PRO_STORAGE_TYPE, 
	IC_Err_READ_ILLEGAL_PRO_STORAGE_FORKED_TYPE, 
	IC_Err_READ_ILLEGAL_PRO_STORAGE_PASCAL_TYPE, 
	IC_Err_ORIGIN_NOT_ZERO, 
	IC_Err_ALREADY_PREPARED, 
	IC_Err_NO_DIR_ENTRY, 
	IC_Err_FILE_TOO_LARGE, 
	IC_Err_ENTRY_NOT_FOUND, 
	IC_Err_FILE_ALREADY_DELETED, 
	IC_Err_DIR_ALREADY_EMPTY, 
	IC_Err_BLOCK_BOUNDARIES, 
	IC_Err_CANT_WRITE_MORE_THAN_1, 
	IC_Err_COULD_NOT_LOAD_PREFS, 
	IC_Err_READ_ILLEGAL_TRACK_SECTOR,
	IC_Err_FILE_LOCKED,
	IC_Err_DISK_LOCKED,
	IC_Err_FILE_OR_DISK_LOCKED,
	IC_Err_FILE_ALREADY_EXISTS,
	IC_Err_INVISIBLE_FILE,
	IC_Err_NOT_A_BLOCK_DEVICE,
	IC_Err_NOT_A_SECTOR_DEVICE,
	IC_Err_CANT_READ_PASCAL_BLOCK, 

	IC_Err_NUMTYPES
} IC_ErrType;

typedef	char			ErrorString[128];

void		QuietErrors(Boolean quietB);
Boolean		ReportPendingErrors(void);
Boolean		ReportErrorStr(OSErr err, char *errStr);
Boolean		ReportError(OSErr err);	//	always returns TRUE
void		AlertID(char *errString, long errNum);
void		ReportOSErr(OSErr err);

#define		FE(_FAILURE_, _ERROR_)		\
	if (_FAILURE_) { ReportError(err = (_ERROR_)); goto error; }

#define		FOSE(_FAIL_) {		\
	err = (_FAIL_);				\
	if (err) { ReportErrorStr(err, #_FAIL_); goto error; }}

#define	TRYIT	{Boolean		success = TRUE;
#define	CATCHIT	}	goto done;	error:	{
#define	ENDTIT	}	done:

long	AssertFailed(
	const char *assertion, 
	const char *file_name, 
	long line_number);

#define	ASSERT(x) (!((x) || AssertFailed(#x,__FILE__,__LINE__)))

#define	ERR(_x)		if (!err) err = (_x)
#define	ERR2(_x)	err2 = (_x); ERR(err2);

void		ReportFreeSpace(unsigned long neededMem);

#endif